package top.doudou.common.cloud;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import top.doudou.base.exception.CustomException;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

/**
 * 本地上传
 *
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-11-01 14:21
 * @Version V1.0
 */
public class LocalCloudStorageService extends AbstractCloudStorageService {

    public LocalCloudStorageService(CloudStorageProperties config){
        this.config = config;
    }

    @Override
    public String upload(byte[] data, String path) {
        return upload(new ByteArrayInputStream(data), path);
    }

    @Override
    public String upload(InputStream inputStream, String path) {
        String localPath = config.getLocalPath();
        File file = new File(StringUtils.isBlank(localPath)? "" : localPath + "/" + path);
        try {
            FileUtils.copyToFile(inputStream, file);
        } catch (IOException e) {
            throw new CustomException(e);
        }
        return config.getDomain() + "/" + path;
    }

    @Override
    public String uploadSuffix(byte[] data, String suffix) {
        return upload(data, getPath(config.getPrefix(), suffix));
    }

    /**
     * 文件上传
     *
     * @param data   文件字节数组
     * @param prefix 路径前缀
     * @param suffix 后缀(一般为文件的类型比如jgp)
     * @return 返回http地址
     */
    @Override
    public String uploadSuffix(byte[] data, String prefix, String suffix) {
        return uploadSuffix(new ByteArrayInputStream(data),prefix,suffix);
    }

    @Override
    public String uploadSuffix(InputStream inputStream, String suffix) {
        return upload(inputStream, getPath(config.getPrefix(), suffix));
    }

    /**
     * 文件上传
     *
     * @param inputStream 字节流
     * @param prefix      路径前缀
     * @param suffix      后缀(一般为文件的类型比如jgp)
     * @return 返回http地址
     */
    @Override
    public String uploadSuffix(InputStream inputStream, String prefix, String suffix) {
        String configPrefix = config.getPrefix();
        if(StringUtils.isBlank(configPrefix)){
            return upload(inputStream, getPath(prefix, suffix));
        }
        if(prefix.startsWith("/") || prefix.startsWith("\\") ){
            return upload(inputStream, getPath(configPrefix+prefix, suffix));
        }
        return upload(inputStream, getPath(configPrefix+File.separator+prefix, suffix));
    }
}
