package top.doudou.common.email;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.io.Serializable;

/**
 * 主要获取配置的用户信息
 *
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-11-01 14:21
 * @Version V1.0
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "spring.mail")
@ApiModel(value = "邮件配置信息")
public class EmailProperties implements Serializable {

    private static final long serialVersionUID = 6481869795480948460L;

    private String username;

    private String form;
}