package top.doudou.common.email;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-11-03 10:51
 * @Version V1.0
 */
@Data
public class SendEmailDto implements Serializable {

    @ApiModelProperty("接收人邮箱")
    private String[] to;

    @ApiModelProperty("主题")
    private String subject;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("抄送人")
    private String[] cc;

    @ApiModelProperty("模板参数-->使用模板时需要传入的参数")
    private Map<String, Object> model;

    @ApiModelProperty("邮件附件,key为附件的名字,value为file")
    private Map<String, File> annex;

    @ApiModelProperty("html模板路径(相对路径)  Thymeleaf的默认配置期望所有HTML文件都放在 **resources/templates ** 目录下，以.html扩展名结尾。")
    private String template;

    public SendEmailDto(){}

    public void setTo(String... to){
        this.to = to;
    }

    public void setTo(List<String> to){
        this.to = (String[])to.toArray();
    }

    public void setCc(String... cc){
        this.cc = cc;
    }

    public void setCc(List<String> cc){
        this.cc = (String[])cc.toArray();
    }

}
