package top.doudou.common.sms;

import com.alibaba.fastjson.JSON;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import lombok.extern.slf4j.Slf4j;
import top.doudou.base.exception.CustomException;
import top.doudou.base.util.FastAssert;

import java.util.Map;

/**
 * 阿里云短信服务
 *
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-11-01 14:21
 * @Version V1.0
 */
@Slf4j
public class AliCloudSmsHandlerService extends SmsHandlerService {
    /**
     * 短信API产品名称（短信产品名固定，无需修改）
     */
    private final String PRODUCT = "Dysmsapi";
    /**
     * 短信API产品域名（接口地址固定，无需修改）
     */
    private final String DOMAIN = "dysmsapi.aliyuncs.com";

    private IClientProfile profile;


    public AliCloudSmsHandlerService(SmsProperties config){
        FastAssert.notEmpty(config.getAccessKey(),"accessKey不能为空");
        FastAssert.notEmpty(config.getAccessSecret(),"accessSecret不能为空");
        FastAssert.notEmpty(config.getSignName(),"短信签名不能为空");
        FastAssert.notEmpty(config.getTemplateId(),"短信默认的模板不能为空");
        FastAssert.notEmpty(config.getRegionId(),"地区不能为空");
        this.config = config;
        //初始化
        init();
    }

    private void init(){
        profile = DefaultProfile.getProfile("cn-hangzhou", config.getAccessKey(), config.getAccessSecret());
        DefaultProfile.addEndpoint(config.getRegionId(),PRODUCT,DOMAIN);
    }

    @Override
    public boolean sendSms(String mobile, Map<String, String> params) {
        return this.sendSms(mobile, params, config.getSignName(), config.getTemplateId());
    }


    @Override
    public boolean sendSms(String mobile, Map<String, String> params, String signName, String template) {
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        System.setProperty("sun.net.client.defaultReadTimeout", "30000");

        //组装请求对象
        SendSmsRequest request = new SendSmsRequest();
        request.setSysMethod(MethodType.POST);
        //待发送手机号，支持以逗号分隔的形式进行批量调用，批量上限为1000个手机号码，批量调用相对于单条调用及时性稍有延迟，验证码类型的短信推荐使用单条调用的方式
        //发送国际/港澳台消息时，接收号码格式为00+国际区号+号码，如"0085200000000"
        request.setPhoneNumbers(mobile);
        //短信签名-可在短信控制台中找到
        request.setSignName(signName);
        //短信模板-可在短信控制台中找到
        request.setTemplateCode(template);
        //参数
        if(null != params || !params.isEmpty()){
            request.setTemplateParam(JSON.toJSONString(params));
        }
        try {
            IAcsClient acsClient = new DefaultAcsClient(profile);
            SendSmsResponse response = acsClient.getAcsResponse(request);
            if(!"ok".equalsIgnoreCase(response.getCode())){
                throw new CustomException(response.getMessage());
            }
            log.debug("发送短信成功,接收人的号码为：{}",mobile);
        } catch (ClientException e) {
            log.error("发送短信失败-->{}",mobile);
            throw new CustomException(e);
        }
        return true;
    }
}
