package top.doudou.common.sms;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.doudou.base.exception.CustomException;

/**
 * 短信Factory
 *
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-11-01 14:21
 * @Version V1.0
 */
@Configuration
@EnableConfigurationProperties(SmsProperties.class)
public class SmsHandlerFactory {

    @Autowired
    private SmsProperties smsProperties;

    @Bean
    public SmsHandlerService smsService(){
        if(null == smsProperties.getPlatform()){
            return null;
        }
        switch (smsProperties.getPlatform()){
            case 1:
                return new AliCloudSmsHandlerService(smsProperties);
            case 2:
                return new TencentSmsHandlerService(smsProperties);
            default:
                throw new CustomException("请配置短信的配置,如不使用短信模块,请将sms.enabled设置为false," +
                        "如果为阿里云则需要配置sms下属性platform=1、accessKey、accessSecret、regionId、signName、templateId，" +
                        "如果为腾讯云则需要配置sms属性下platform=2、appKey、appId、signName、templateId");
        }
    }
}
