package top.doudou.common.sms;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.io.Serializable;

/**
 * 短信配置信息
 * 阿里云短信配置需配置 accessKey accessSecret regionId signName、templateId
 * 腾讯云短信配置需配置 appKey  appId signName、templateId
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-11-01 14:21
 * @Version V1.0
 */
@Data
@ApiModel(value = "短信配置信息")
@Configuration
@ConfigurationProperties(prefix = "sms")
public class SmsProperties implements Serializable {

    private static final long serialVersionUID = 4536619872673239127L;

    @ApiModelProperty(value = "平台 1：阿里云  2：腾讯云",required = true)
    private Integer platform;

    @ApiModelProperty(value = "阿里云AccessKey")
    private String accessKey;

    @ApiModelProperty(value = "阿里云AccessKeySecret")
    private String accessSecret;

    @ApiModelProperty(value = "腾讯云AppId")
    private Integer appId;

    @ApiModelProperty(value = "腾讯云AppKey")
    private String appKey;

    @ApiModelProperty(value = "短信签名")
    private String signName;

    @ApiModelProperty(value = "短信默认使用模板")
    private String templateId;

    @ApiModelProperty(value = "地区id")
    private String regionId ;
}