package top.doudou.common.sms;

import com.github.qcloudsms.SmsSingleSender;
import com.github.qcloudsms.SmsSingleSenderResult;
import lombok.extern.slf4j.Slf4j;
import top.doudou.base.exception.CustomException;
import top.doudou.base.util.FastAssert;

import java.util.ArrayList;
import java.util.Map;

/**
 * 腾讯云短信服务
 *
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-11-01 14:21
 * @Version V1.0
 */
@Slf4j
public class TencentSmsHandlerService extends SmsHandlerService {

    public TencentSmsHandlerService(SmsProperties config){
        FastAssert.notEmpty(config.getAppId(),"appId不能为空");
        FastAssert.notEmpty(config.getAppKey(),"appKey不能为空");
        FastAssert.notEmpty(config.getSignName(),"短信签名不能为空");
        FastAssert.notEmpty(config.getTemplateId(),"短信默认的模板不能为空");
        this.config = config;
    }

    @Override
    public boolean sendSms(String mobile, Map<String, String> params) {
        return this.sendSms(mobile, params, config.getSignName(), config.getTemplateId());
    }

    @Override
    public boolean sendSms(String mobile, Map<String, String> params, String signName, String template) {
        SmsSingleSender sender = new SmsSingleSender(config.getAppId(), config.getAppKey());
        //短信参数
        ArrayList<String> paramsList = new ArrayList<>();
        if(null != params || !params.isEmpty()){
            for(String value : params.values()){
                paramsList.add(value);
            }
        }
        try {
            SmsSingleSenderResult result = sender.sendWithParam("86", mobile, Integer.parseInt(template), paramsList, signName, null, null);
            if(result.result != 0){
                throw new CustomException(result.errMsg);
            }
            log.debug("发送短信成功,接收人的号码为：{}",mobile);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("给{}发送短信错误",mobile);
            throw new CustomException(e);
        }
        return true ;
    }
}
