/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.cloud;

import com.aliyun.oss.OSSClient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.doudou.base.exception.CustomException;
import top.doudou.common.cloud.AbstractCloudStorageService;
import top.doudou.common.cloud.CloudStorageProperties;

public class AliyunCloudStorageService
extends AbstractCloudStorageService {
    private static final Logger log = LoggerFactory.getLogger(AliyunCloudStorageService.class);

    public AliyunCloudStorageService(CloudStorageProperties config) {
        this.config = config;
    }

    @Override
    public String upload(byte[] data, String path) {
        return this.upload(new ByteArrayInputStream(data), path);
    }

    @Override
    public String upload(InputStream inputStream, String path) {
        OSSClient client = new OSSClient(this.config.getEndPoint(), this.config.getAccessKey(), this.config.getSecretKey());
        try {
            client.putObject(this.config.getBucketName(), path, inputStream);
            client.shutdown();
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230\u963f\u91cc\u4e91oss\u5931\u8d25");
            throw new CustomException((Throwable)e);
        }
        return String.format("%s/%s", this.config.getDomain(), path);
    }

    @Override
    public String uploadSuffix(byte[] data, String suffix) {
        return this.upload(data, this.getPath(this.config.getPrefix(), suffix));
    }

    @Override
    public String uploadSuffix(byte[] data, String prefix, String suffix) {
        return this.uploadSuffix(new ByteArrayInputStream(data), prefix, suffix);
    }

    @Override
    public String uploadSuffix(InputStream inputStream, String suffix) {
        return this.upload(inputStream, this.getPath(this.config.getPrefix(), suffix));
    }

    @Override
    public String uploadSuffix(InputStream inputStream, String prefix, String suffix) {
        String configPrefix = this.config.getPrefix();
        if (StringUtils.isBlank((CharSequence)configPrefix)) {
            return this.upload(inputStream, this.getPath(prefix, suffix));
        }
        if (prefix.startsWith("/")) {
            return this.upload(inputStream, this.getPath(configPrefix + prefix, suffix));
        }
        if (prefix.startsWith("\\")) {
            return this.upload(inputStream, this.getPath(configPrefix + "/" + prefix.substring(1), suffix));
        }
        return this.upload(inputStream, this.getPath(configPrefix + "/" + prefix, suffix));
    }
}

