/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.cloud;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.doudou.common.cloud.AbstractCloudStorageService;
import top.doudou.common.cloud.AliyunCloudStorageService;
import top.doudou.common.cloud.CloudStorageProperties;
import top.doudou.common.cloud.LocalCloudStorageService;
import top.doudou.common.cloud.QcloudCloudStorageService;
import top.doudou.common.cloud.QiniuCloudStorageService;

@Configuration
@EnableConfigurationProperties(value={CloudStorageProperties.class})
public class CloudStorageHandlerService {
    @Autowired
    private CloudStorageProperties config;

    @Bean
    public AbstractCloudStorageService cloudStorageService() {
        if (null == this.config.getType()) {
            return new LocalCloudStorageService(this.config);
        }
        switch (this.config.getType()) {
            case 1: {
                return new QiniuCloudStorageService(this.config);
            }
            case 2: {
                return new AliyunCloudStorageService(this.config);
            }
            case 3: {
                return new QcloudCloudStorageService(this.config);
            }
        }
        return new LocalCloudStorageService(this.config);
    }
}

