/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.cloud;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import top.doudou.base.exception.CustomException;
import top.doudou.common.cloud.AbstractCloudStorageService;
import top.doudou.common.cloud.CloudStorageProperties;

public class LocalCloudStorageService
extends AbstractCloudStorageService {
    public LocalCloudStorageService(CloudStorageProperties config) {
        this.config = config;
    }

    @Override
    public String upload(byte[] data, String path) {
        return this.upload(new ByteArrayInputStream(data), path);
    }

    @Override
    public String upload(InputStream inputStream, String path) {
        String localPath = this.config.getLocalPath();
        File file = new File(StringUtils.isBlank((CharSequence)localPath) ? "" : localPath + "/" + path);
        try {
            FileUtils.copyToFile((InputStream)inputStream, (File)file);
        }
        catch (IOException e) {
            throw new CustomException((Throwable)e);
        }
        return this.config.getDomain() + "/" + path;
    }

    @Override
    public String uploadSuffix(byte[] data, String suffix) {
        return this.upload(data, this.getPath(this.config.getPrefix(), suffix));
    }

    @Override
    public String uploadSuffix(byte[] data, String prefix, String suffix) {
        return this.uploadSuffix(new ByteArrayInputStream(data), prefix, suffix);
    }

    @Override
    public String uploadSuffix(InputStream inputStream, String suffix) {
        return this.upload(inputStream, this.getPath(this.config.getPrefix(), suffix));
    }

    @Override
    public String uploadSuffix(InputStream inputStream, String prefix, String suffix) {
        String configPrefix = this.config.getPrefix();
        if (StringUtils.isBlank((CharSequence)configPrefix)) {
            return this.upload(inputStream, this.getPath(prefix, suffix));
        }
        if (prefix.startsWith("/") || prefix.startsWith("\\")) {
            return this.upload(inputStream, this.getPath(configPrefix + prefix, suffix));
        }
        return this.upload(inputStream, this.getPath(configPrefix + File.separator + prefix, suffix));
    }
}

