/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.cloud;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import top.doudou.base.exception.CustomException;
import top.doudou.common.cloud.AbstractCloudStorageService;
import top.doudou.common.cloud.CloudStorageProperties;

public class QcloudCloudStorageService
extends AbstractCloudStorageService {
    private COSCredentials credentials;
    private ClientConfig clientConfig;

    public QcloudCloudStorageService(CloudStorageProperties config) {
        this.config = config;
        this.init();
    }

    private void init() {
        this.credentials = new BasicCOSCredentials(this.config.getAccessKey(), this.config.getSecretKey());
        this.clientConfig = new ClientConfig(new Region(this.config.getRegion()));
    }

    @Override
    public String upload(byte[] data, String path) {
        return this.upload(new ByteArrayInputStream(data), path);
    }

    @Override
    public String upload(InputStream inputStream, String path) {
        try {
            COSClient client = new COSClient(this.credentials, this.clientConfig);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)inputStream.available());
            String bucketName = this.config.getBucketName() + "-" + this.config.getAppId();
            PutObjectRequest request = new PutObjectRequest(bucketName, path, inputStream, metadata);
            PutObjectResult result = client.putObject(request);
            client.shutdown();
            if (result.getETag() == null) {
                throw new CustomException(result.getDateStr());
            }
        }
        catch (IOException e) {
            throw new CustomException("\u4e0a\u4f20\u5230\u817e\u8baf\u4e91\u5931\u8d25");
        }
        return String.format("%s/%s", this.config.getDomain(), path);
    }

    @Override
    public String uploadSuffix(byte[] data, String suffix) {
        return this.upload(data, this.getPath(this.config.getPrefix(), suffix));
    }

    @Override
    public String uploadSuffix(byte[] data, String prefix, String suffix) {
        return this.uploadSuffix(new ByteArrayInputStream(data), prefix, suffix);
    }

    @Override
    public String uploadSuffix(InputStream inputStream, String suffix) {
        return this.upload(inputStream, this.getPath(this.config.getPrefix(), suffix));
    }

    @Override
    public String uploadSuffix(InputStream inputStream, String prefix, String suffix) {
        String configPrefix = this.config.getPrefix();
        if (StringUtils.isBlank((CharSequence)configPrefix)) {
            return this.upload(inputStream, this.getPath(prefix, suffix));
        }
        if (prefix.startsWith("/")) {
            return this.upload(inputStream, this.getPath(configPrefix + prefix, suffix));
        }
        if (prefix.startsWith("\\")) {
            return this.upload(inputStream, this.getPath(configPrefix + "/" + prefix.substring(1), suffix));
        }
        return this.upload(inputStream, this.getPath(configPrefix + "/" + prefix, suffix));
    }
}

