/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.cloud;

import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.doudou.base.exception.CustomException;
import top.doudou.common.cloud.AbstractCloudStorageService;
import top.doudou.common.cloud.CloudStorageProperties;

public class QiniuCloudStorageService
extends AbstractCloudStorageService {
    private static final Logger log = LoggerFactory.getLogger(QiniuCloudStorageService.class);
    private UploadManager uploadManager;
    private String token;

    public QiniuCloudStorageService(CloudStorageProperties config) {
        this.config = config;
        this.init();
    }

    private void init() {
        this.uploadManager = new UploadManager(new Configuration(Zone.autoZone()));
        this.token = Auth.create((String)this.config.getAccessKey(), (String)this.config.getSecretKey()).uploadToken(this.config.getBucketName());
    }

    @Override
    public String upload(byte[] data, String path) {
        try {
            Response res = this.uploadManager.put(data, path, this.token);
            if (!res.isOK()) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5230\u4e03\u725b\u4e91\u5931\u8d25");
                throw new CustomException(res.toString());
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230\u4e03\u725b\u4e91\u5931\u8d25");
            throw new CustomException((Throwable)e);
        }
        return String.format("%s/%s", this.config.getDomain(), path);
    }

    @Override
    public String upload(InputStream inputStream, String path) {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            return this.upload(data, path);
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230\u4e03\u725b\u4e91\u5931\u8d25");
            throw new CustomException((Throwable)e);
        }
    }

    @Override
    public String uploadSuffix(byte[] data, String suffix) {
        return this.upload(data, this.getPath(this.config.getPrefix(), suffix));
    }

    @Override
    public String uploadSuffix(byte[] data, String prefix, String suffix) {
        return this.uploadSuffix(new ByteArrayInputStream(data), prefix, suffix);
    }

    @Override
    public String uploadSuffix(InputStream inputStream, String suffix) {
        return this.upload(inputStream, this.getPath(this.config.getPrefix(), suffix));
    }

    @Override
    public String uploadSuffix(InputStream inputStream, String prefix, String suffix) {
        String configPrefix = this.config.getPrefix();
        if (StringUtils.isBlank((CharSequence)configPrefix)) {
            return this.upload(inputStream, this.getPath(prefix, suffix));
        }
        if (prefix.startsWith("/")) {
            return this.upload(inputStream, this.getPath(configPrefix + prefix, suffix));
        }
        if (prefix.startsWith("\\")) {
            return this.upload(inputStream, this.getPath(configPrefix + "/" + prefix.substring(1), suffix));
        }
        return this.upload(inputStream, this.getPath(configPrefix + "/" + prefix, suffix));
    }
}

