/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.email;

import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import top.doudou.base.exception.CustomException;
import top.doudou.common.email.EmailProperties;
import top.doudou.common.email.SendEmailDto;

@Component
@EnableConfigurationProperties(value={EmailProperties.class})
@ConditionalOnProperty(name={"email.enabled"}, havingValue="true", matchIfMissing=false)
public class EmailHandler {
    private static final Logger log = LoggerFactory.getLogger(EmailHandler.class);
    @Autowired
    private JavaMailSender javaMailSender;
    @Autowired
    private EmailProperties emailProperties;
    @Autowired
    private TemplateEngine templateEngine;
    public static final Pattern PLATE_NUMBER = Pattern.compile("\\w+@\\w+\\.[a-z]+(\\.[a-z]+)?");

    public boolean sendEmail(SendEmailDto sendEmail) {
        this.checkParam(sendEmail);
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(this.emailProperties.getUsername());
        message.setTo(sendEmail.getTo());
        message.setSubject(sendEmail.getSubject());
        message.setText(sendEmail.getContent());
        try {
            this.javaMailSender.send(message);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u7eaf\u6587\u672c\u7684\u90ae\u4ef6\u5931\u8d25");
            throw new CustomException((Throwable)e);
        }
        return true;
    }

    public boolean sendAttachmentEmail(SendEmailDto sendEmail) {
        this.checkParam(sendEmail);
        try {
            MimeMessageHelper mimeMessageHelper = this.createMimeMessageHelper(sendEmail);
            mimeMessageHelper.setText(sendEmail.getContent(), true);
            this.javaMailSender.send(mimeMessageHelper.getMimeMessage());
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u5e26\u9644\u4ef6\u7684\u666e\u901a\u90ae\u4ef6\u7684\u90ae\u4ef6\u5931\u8d25");
            throw new CustomException((Throwable)e);
        }
        return true;
    }

    public boolean sendHtmlEmail(SendEmailDto sendEmail) {
        return this.sendHtmlEmail(sendEmail, true);
    }

    public boolean sendHtmlEmail(SendEmailDto sendEmail, boolean isShowHtml) {
        this.checkParam(sendEmail);
        try {
            MimeMessageHelper mimeMessageHelper = this.createMimeMessageHelper(sendEmail);
            mimeMessageHelper.setText(sendEmail.getContent(), isShowHtml);
            this.javaMailSender.send(mimeMessageHelper.getMimeMessage());
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u7684\u90ae\u4ef6\u662f\u5bcc\u6587\u672c\u7684\u90ae\u4ef6\u5931\u8d25");
            throw new CustomException((Throwable)e);
        }
        return true;
    }

    public boolean sendThymeleafEmail(SendEmailDto sendEmailDto) {
        this.checkParam(sendEmailDto);
        try {
            MimeMessageHelper mimeMessageHelper = this.createMimeMessageHelper(sendEmailDto);
            Context ctx = new Context();
            ctx.setVariables(sendEmailDto.getModel());
            String emailText = this.templateEngine.process(sendEmailDto.getTemplate(), (IContext)ctx);
            mimeMessageHelper.setText(emailText, true);
            this.javaMailSender.send(mimeMessageHelper.getMimeMessage());
        }
        catch (Exception e) {
            log.error("\u53d1\u9001html\u6a21\u677f\u90ae\u4ef6\u7684\u90ae\u4ef6\u5931\u8d25");
            throw new CustomException((Throwable)e);
        }
        return true;
    }

    private MimeMessageHelper createMimeMessageHelper(SendEmailDto sendEmailDto) throws MessagingException {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, true, "utf-8");
        mimeMessageHelper.setFrom(this.emailProperties.getUsername());
        mimeMessageHelper.setTo(sendEmailDto.getTo());
        if (null != sendEmailDto.getCc()) {
            mimeMessageHelper.setBcc(sendEmailDto.getCc());
        }
        mimeMessageHelper.setSubject(sendEmailDto.getSubject());
        this.addAttachment(mimeMessageHelper, sendEmailDto.getAnnex());
        return mimeMessageHelper;
    }

    private boolean isEmail(String ... email) {
        if (null == email || email.length == 0) {
            throw new CustomException("\u90ae\u4ef6\u5730\u5740\u51fa\u9519");
        }
        for (int i = 0; i < email.length; ++i) {
            if (PLATE_NUMBER.matcher(email[i]).find()) continue;
            return false;
        }
        return true;
    }

    private void checkParam(SendEmailDto sendEmailDto) {
        if (null != sendEmailDto.getTo() && !this.isEmail(sendEmailDto.getTo())) {
            throw new CustomException("\u6536\u4ef6\u4eba\u90ae\u4ef6\u5730\u5740\u9519\u8bef");
        }
        if (null != sendEmailDto.getCc() && !this.isEmail(sendEmailDto.getCc())) {
            throw new CustomException("\u6284\u9001\u4eba\u90ae\u4ef6\u5730\u5740\u9519\u8bef");
        }
    }

    private void addAttachment(MimeMessageHelper mimeMessageHelper, Map<String, File> attachment) {
        if (null != attachment && !attachment.isEmpty()) {
            attachment.forEach((key, value) -> {
                try {
                    mimeMessageHelper.addAttachment(key, value);
                }
                catch (MessagingException e) {
                    log.error("\u90ae\u4ef6\u6dfb\u52a0\u9644\u4ef6\u9519\u8bef");
                    throw new CustomException((Throwable)e);
                }
            });
        }
    }
}

