/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.sms;

import com.alibaba.fastjson.JSON;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.doudou.base.exception.CustomException;
import top.doudou.base.util.FastAssert;
import top.doudou.common.sms.SmsHandlerService;
import top.doudou.common.sms.SmsProperties;

public class AliCloudSmsHandlerService
extends SmsHandlerService {
    private static final Logger log = LoggerFactory.getLogger(AliCloudSmsHandlerService.class);
    private final String PRODUCT = "Dysmsapi";
    private final String DOMAIN = "dysmsapi.aliyuncs.com";
    private IClientProfile profile;

    public AliCloudSmsHandlerService(SmsProperties config) {
        FastAssert.notEmpty((Object)config.getAccessKey(), (String)"accessKey\u4e0d\u80fd\u4e3a\u7a7a");
        FastAssert.notEmpty((Object)config.getAccessSecret(), (String)"accessSecret\u4e0d\u80fd\u4e3a\u7a7a");
        FastAssert.notEmpty((Object)config.getSignName(), (String)"\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        FastAssert.notEmpty((Object)config.getTemplateId(), (String)"\u77ed\u4fe1\u9ed8\u8ba4\u7684\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        FastAssert.notEmpty((Object)config.getRegionId(), (String)"\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        this.config = config;
        this.init();
    }

    private void init() {
        this.profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.config.getAccessKey(), (String)this.config.getAccessSecret());
        DefaultProfile.addEndpoint((String)this.config.getRegionId(), (String)"Dysmsapi", (String)"dysmsapi.aliyuncs.com");
    }

    @Override
    public boolean sendSms(String mobile, Map<String, String> params) {
        return this.sendSms(mobile, params, this.config.getSignName(), this.config.getTemplateId());
    }

    @Override
    public boolean sendSms(String mobile, Map<String, String> params, String signName, String template) {
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        System.setProperty("sun.net.client.defaultReadTimeout", "30000");
        SendSmsRequest request = new SendSmsRequest();
        request.setSysMethod(MethodType.POST);
        request.setPhoneNumbers(mobile);
        request.setSignName(signName);
        request.setTemplateCode(template);
        if (null != params || !params.isEmpty()) {
            request.setTemplateParam(JSON.toJSONString(params));
        }
        try {
            DefaultAcsClient acsClient = new DefaultAcsClient(this.profile);
            SendSmsResponse response = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
            if (!"ok".equalsIgnoreCase(response.getCode())) {
                throw new CustomException(response.getMessage());
            }
            log.debug("\u53d1\u9001\u77ed\u4fe1\u6210\u529f,\u63a5\u6536\u4eba\u7684\u53f7\u7801\u4e3a\uff1a{}", (Object)mobile);
        }
        catch (ClientException e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25-->{}", (Object)mobile);
            throw new CustomException((Throwable)e);
        }
        return true;
    }
}

