/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.sms;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.doudou.base.exception.CustomException;
import top.doudou.common.sms.AliCloudSmsHandlerService;
import top.doudou.common.sms.SmsHandlerService;
import top.doudou.common.sms.SmsProperties;
import top.doudou.common.sms.TencentSmsHandlerService;

@Configuration
@EnableConfigurationProperties(value={SmsProperties.class})
public class SmsHandlerFactory {
    @Autowired
    private SmsProperties smsProperties;

    @Bean
    public SmsHandlerService smsService() {
        if (null == this.smsProperties.getPlatform()) {
            return null;
        }
        switch (this.smsProperties.getPlatform()) {
            case 1: {
                return new AliCloudSmsHandlerService(this.smsProperties);
            }
            case 2: {
                return new TencentSmsHandlerService(this.smsProperties);
            }
        }
        throw new CustomException("\u8bf7\u914d\u7f6e\u77ed\u4fe1\u7684\u914d\u7f6e,\u5982\u4e0d\u4f7f\u7528\u77ed\u4fe1\u6a21\u5757,\u8bf7\u5c06sms.enabled\u8bbe\u7f6e\u4e3afalse,\u5982\u679c\u4e3a\u963f\u91cc\u4e91\u5219\u9700\u8981\u914d\u7f6esms\u4e0b\u5c5e\u6027platform=1\u3001accessKey\u3001accessSecret\u3001regionId\u3001signName\u3001templateId\uff0c\u5982\u679c\u4e3a\u817e\u8baf\u4e91\u5219\u9700\u8981\u914d\u7f6esms\u5c5e\u6027\u4e0bplatform=2\u3001appKey\u3001appId\u3001signName\u3001templateId");
    }
}

