/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.sms;

import com.github.qcloudsms.SmsSingleSender;
import com.github.qcloudsms.SmsSingleSenderResult;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.doudou.base.exception.CustomException;
import top.doudou.base.util.FastAssert;
import top.doudou.common.sms.SmsHandlerService;
import top.doudou.common.sms.SmsProperties;

public class TencentSmsHandlerService
extends SmsHandlerService {
    private static final Logger log = LoggerFactory.getLogger(TencentSmsHandlerService.class);

    public TencentSmsHandlerService(SmsProperties config) {
        FastAssert.notEmpty((Object)config.getAppId(), (String)"appId\u4e0d\u80fd\u4e3a\u7a7a");
        FastAssert.notEmpty((Object)config.getAppKey(), (String)"appKey\u4e0d\u80fd\u4e3a\u7a7a");
        FastAssert.notEmpty((Object)config.getSignName(), (String)"\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        FastAssert.notEmpty((Object)config.getTemplateId(), (String)"\u77ed\u4fe1\u9ed8\u8ba4\u7684\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        this.config = config;
    }

    @Override
    public boolean sendSms(String mobile, Map<String, String> params) {
        return this.sendSms(mobile, params, this.config.getSignName(), this.config.getTemplateId());
    }

    @Override
    public boolean sendSms(String mobile, Map<String, String> params, String signName, String template) {
        SmsSingleSender sender = new SmsSingleSender(this.config.getAppId().intValue(), this.config.getAppKey());
        ArrayList<String> paramsList = new ArrayList<String>();
        if (null != params || !params.isEmpty()) {
            for (String value : params.values()) {
                paramsList.add(value);
            }
        }
        try {
            SmsSingleSenderResult result = sender.sendWithParam("86", mobile, Integer.parseInt(template), paramsList, signName, null, null);
            if (result.result != 0) {
                throw new CustomException(result.errMsg);
            }
            log.debug("\u53d1\u9001\u77ed\u4fe1\u6210\u529f,\u63a5\u6536\u4eba\u7684\u53f7\u7801\u4e3a\uff1a{}", (Object)mobile);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u7ed9{}\u53d1\u9001\u77ed\u4fe1\u9519\u8bef", (Object)mobile);
            throw new CustomException((Throwable)e);
        }
        return true;
    }
}

