package top.doudou.common.verification.code;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import top.doudou.common.redis.RedisUtil;
import top.doudou.common.verification.code.entity.ValidateCodeDo;
import top.doudou.core.exception.CustomException;

import javax.servlet.http.HttpServletRequest;

/**
 * @Description redis存储验证的策略
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-20 17:19
 */
@Component
@ConditionalOnMissingBean(name = "storageStrategy")
public class RedisStorageStrategy implements StorageStrategy<ValidateCodeDo>{

    @Autowired
    private RedisUtil redisUtil;
    /**
     * 保存key
     *
     * @param key
     * @param value
     * @param expire 过期时间(秒)
     */
    @Override
    public void save(String key, ValidateCodeDo value, int expire) {
        redisUtil.set(key,value,Long.valueOf(expire));
    }

    /**
     * 获取
     *
     * @param key
     */
    @Override
    public ValidateCodeDo get(String key) {
        return (ValidateCodeDo)redisUtil.get(key);
    }

    /**
     * 删除
     *
     * @param key
     */
    @Override
    public void delete(String key) {
        redisUtil.del(key);
    }

    /**
     * 生成存储的key
     *
     * @param request
     * @param type      验证码的类型，ValidateCodeType
     * @return
     */
    @Override
    public String createKey(HttpServletRequest request,ValidateCodeType type) {
        String sessionId = request.getSession().getId();
        if(ValidateCodeType.SMS.equals(type)){
            String mobile = request.getParameter(CodeConstant.DEFAULT_PARAMETER_NAME_MOBILE);
            return KEY_PREFIX+type+SPLIT_SYMBOL+mobile + SPLIT_SYMBOL+ sessionId;
        }else if(ValidateCodeType.IMAGE.equals(type)){
            return KEY_PREFIX+type+SPLIT_SYMBOL+sessionId;
        }
        throw new CustomException("暂时不支持该中类型："+type);
    }
}


