package top.doudou.common.verification.code;

import top.doudou.common.verification.code.entity.ValidateCodeDo;

import javax.servlet.http.HttpServletRequest;

/**
 * @Description 存储策略
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-20 17:15
 */
public interface StorageStrategy<T extends ValidateCodeDo> {

    String KEY_PREFIX = "VALIDATE_CODE_";

    /**
     * 分隔符
     */
    String SPLIT_SYMBOL = "_";

    /**
     * 保存key
     * @param key
     * @param value
     * @param expire 过期时间(秒)
     */
    void save(String key,T value,int expire);


    /**
     * 获取
     * @param key
     */
    T get(String key);

    /**
     * 删除
     * @param key
     */
    void delete(String key);

    /**
     * 生成存储的key
     * @param request
     * @return
     */
    String createKey(HttpServletRequest request,ValidateCodeType type);

}
