package top.doudou.common.verification.code;

import org.springframework.web.context.request.ServletWebRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @Description 校验码处理器，封装不同校验码的处理逻辑
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-20 14:47
 */
public interface ValidateCodeProcessor {

    /**
     * 验证码放入session时的前缀
     */
    String SESSION_KEY_PREFIX = "SESSION_KEY_FOR_CODE_";

    /**
     * 创建校验码
     * @param request
     * @param response
     * @throws Exception
     */
    void create(HttpServletRequest request, HttpServletResponse response) ;

    /**
     * 创建校验码
     * @param request
     * @throws Exception
     */
    void create(ServletWebRequest request);

    /**
     * 校验验证码
     *
     * @param request
     * @throws Exception
     */
    void validate(HttpServletRequest request);


    /**
     * 校验验证码
     * @throws Exception
     */
    void validate();
}
