package top.doudou.common.verification.code;

/**
 * @Description 验证码类型
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-20 14:49
 */
public enum ValidateCodeType {

    /**
     * 短信验证码
     */
    SMS {
        @Override
        public String getParamNameOnValidate() {
            return CodeConstant.VALIDATE_CODE_SMS;
        }
    },
    /**
     * 图片验证码
     */
    IMAGE {
        @Override
        public String getParamNameOnValidate() {
            return CodeConstant.VALIDATE_CODE_IMAGE;
        }
    },

    /**
     * 其他验证码类型
     */
    OTHER {
        @Override
        public String getParamNameOnValidate() {
            return CodeConstant.VALIDATE_CODE_OTHER;
        }
    };

    /**
     * 校验时从请求中获取的参数的名字
     * @return
     */
    public abstract String getParamNameOnValidate();
}
