package top.doudou.common.verification.code.adapter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import top.doudou.common.verification.code.ValidateCodeProcessor;
import top.doudou.common.verification.code.ValidateCodeType;
import top.doudou.core.exception.ValidateCodeException;

import java.util.Map;

/**
 * @Description 验证码处理器
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-20 14:45
 */
@Component
public class ValidateCodeProcessorAdapter {

    @Autowired
    private Map<String, ValidateCodeProcessor> validateCodeProcessors;

    public ValidateCodeProcessor findValidateCodeProcessor(ValidateCodeType type) {
        return findValidateCodeProcessor(type.toString().toLowerCase());
    }

    public ValidateCodeProcessor findValidateCodeProcessor(String type) {
        String name = type.toLowerCase() + ValidateCodeProcessor.class.getSimpleName();
        ValidateCodeProcessor processor = validateCodeProcessors.get(name);
        if (processor == null) {
            throw new ValidateCodeException("验证码处理器" + name + "不存在");
        }
        return processor;
    }

}
