package top.doudou.common.verification.code.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import top.doudou.common.verification.code.ValidateCodeProcessor;
import top.doudou.common.verification.code.adapter.ValidateCodeProcessorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @Description 验证码
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-20 14:41
 */
@RestController
@Api(value = "验证码",tags = "验证码")
public class ValidateCodeController {

    @Autowired
    private ValidateCodeProcessorAdapter validateCodeProcessorAdapter;

    /**
     * 创建验证码
     * 根据验证码类型不同，调用不同的 {@link ValidateCodeProcessor}接口实现
     * @param request
     * @param response
     * @param type
     * @throws Exception
     */
    @ApiOperation(value = "生成验证码", notes = "生成验证码")
    @ApiImplicitParams({@ApiImplicitParam(name = "type", value = "验证码的类型(短信验证码SMS/图片验证码IMAGE/其他验证码类型OTHER,如果为短信验证码需要增加mobile参数)", dataType = "ValidateCodeType", required = true)})
    @GetMapping("/code/{type}")
    public void createCode(@PathVariable("type") String type, HttpServletRequest request, HttpServletResponse response) {
        validateCodeProcessorAdapter.findValidateCodeProcessor(type).create(request,response);
    }
}
