package top.doudou.common.verification.code.image;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.ServletRequestUtils;
import top.doudou.base.constant.SysConstant;
import top.doudou.common.verification.code.ValidateCodeGenerator;
import top.doudou.common.verification.code.entity.ImageCodeDo;
import top.doudou.common.verification.code.properties.ValidateCodeProperties;

import javax.servlet.http.HttpServletRequest;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.Random;

/**
 * @Description 图片验证码生成器
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-20 15:07
 */
@Component("imageValidateCodeGenerator")
public class ImageCodeGenerator implements ValidateCodeGenerator {

    @Autowired
    private ValidateCodeProperties validateCodeProperties;

    /**
     * 生成验证码
     *
     * @param request
     * @return
     */
    @Override
    public ImageCodeDo generate(HttpServletRequest request) {
        int width = validateCodeProperties.getImage().getWidth();
        int height = validateCodeProperties.getImage().getHeight();
        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);

        Graphics g = image.getGraphics();
        Random random = new Random();
        g.fillRect(0, 0, width, height);
        g.setFont(new Font("Times New Roman", Font.ITALIC, 20));
        for (int i = 0; i < 155; i++) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            g.drawLine(x, y, x + xl, y + yl);
        }

        String sRand = "";
        for (int i = 0; i < ServletRequestUtils.getIntParameter(request,SysConstant.CODE_LENGTH, validateCodeProperties.getImage().getLength()); i++) {
            String rand = String.valueOf(random.nextInt(10));
            sRand += rand;
            g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
            g.drawString(rand, 13 * i + 6, 16);
        }

        g.dispose();

        return new ImageCodeDo(image, sRand);
    }


}
