package top.doudou.common.verification.code.image;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import top.doudou.common.verification.code.AbstractValidateCodeProcessor;
import top.doudou.common.verification.code.entity.ImageCodeDo;
import top.doudou.core.exception.CustomException;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @Description 图片验证码处理器
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-20 15:07
 */
@Component("imageValidateCodeProcessor")
@ConditionalOnMissingBean(name = "imageValidateCodeProcessor")
public class ImageCodeProcessor extends AbstractValidateCodeProcessor<ImageCodeDo> {

    /**
     * 发送图形验证码，将其写到响应中
     */
    @Override
    protected void send(HttpServletRequest request, HttpServletResponse response, ImageCodeDo imageCodeDo) {
        response.setContentType("image/jpeg");
        try {
            ImageIO.write(imageCodeDo.getImage(), "JPEG", response.getOutputStream());
        } catch (IOException e) {
            throw new CustomException(e);
        }
    }

}
