package top.doudou.common.verification.code.properties;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jdk.nashorn.internal.ir.annotations.Ignore;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 短信验证码的参数信息
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2021-10-28 10:28
 */
@Data
@ApiModel("短信验证码的参数信息")
public class SmsCodeProperties implements Serializable {

    @ApiModelProperty("验证码的长度")
    private int length = 4;

    @ApiModelProperty("过期时间")
    private int expireIn = 60;

    //防止恶意请求  发送策略
    @ApiModelProperty("24h内同一手机号最多发送好多条短信")
    private int dayMax = 5;

    @ApiModelProperty("好多秒内不能重复发送")
    private int coolingTime = 20;

    /**
     * 需要验证图形验证码的url地址
     */
    @Ignore
    private List<String> urls;
}
