/**
 * 
 */
package top.doudou.common.verification.code.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.io.Serializable;

/**
 * @Description 验证码配置信息
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2021-10-28 10:28
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "custom.validate.code")
public class ValidateCodeProperties implements Serializable {

	/**
	 * 图形验证码
	 */
	private ImageCodeProperties image = new ImageCodeProperties();


	/**
	 * 短信验证码
	 */
	private SmsCodeProperties sms = new SmsCodeProperties();
	
}
