package top.doudou.common.verification.code.sms;

import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import top.doudou.common.redis.RedisUtil;
import top.doudou.common.redis.adapter.SmsStrategyAdapter;
import top.doudou.common.sms.details.client.SmsSendClient;
import top.doudou.common.sms.details.entity.SendSmsDto;
import top.doudou.common.sms.details.properties.ALiYunProperties;
import top.doudou.common.verification.code.properties.SmsCodeProperties;
import top.doudou.common.verification.code.properties.ValidateCodeProperties;
import top.doudou.core.properties.CustomLogProperties;

import java.util.Map;

/**
 * @Description 默认的发送器
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-20 14:56
 */
@Slf4j
@Component
@ConditionalOnMissingBean(name = "smsCodeSender")
@EnableConfigurationProperties({ALiYunProperties.class})
public class DefaultSmsCodeSender implements SmsCodeSender{

    @Autowired
    private SmsSendClient smsSendClient;

    @Autowired
    private ValidateCodeProperties validateCodeProperties;

    @Autowired
    private RedisUtil redisUtil;

    /**
     * 发送短信
     *
     * @param mobile 手机号码
     * @param code   验证码
     */
    @Override
    public void send(String mobile, String code) {
        log.info("默认发送短信验证码的方式     ------>  手机号:{}     验证码:{}",mobile,code);
        SmsCodeProperties sms = validateCodeProperties.getSms();
        SmsStrategyAdapter smsStrategyAdapter = new SmsStrategyAdapter(redisUtil,sms.getDayMax(),sms.getCoolingTime());
        smsStrategyAdapter.handler(mobile);
        log.info("  发送成功 --》");
//        SendSmsDto sendSmsDto = new SendSmsDto();
//        sendSmsDto.setSignName("万网鑫成");
//        sendSmsDto.setTemplateCode("SMS_195705349");
//        Map<String, String> map = Maps.newHashMap();
//        map.put("code", code);
//        sendSmsDto.setTemplateParam(map);
//        sendSmsDto.setPhone(mobile);
//        smsSendClient.sendSms(sendSmsDto);

    }
}
