package top.doudou.common.verification.code.sms;

import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import top.doudou.common.verification.code.ValidateCodeGenerator;
import top.doudou.common.verification.code.entity.ValidateCodeDo;
import top.doudou.common.verification.code.properties.ValidateCodeProperties;

import javax.servlet.http.HttpServletRequest;

/**
 * @Description 验证码生成器
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-20 15:00
 */
@Component("smsValidateCodeGenerator")
public class SmsCodeGenerator implements ValidateCodeGenerator {

    @Autowired
    private ValidateCodeProperties validateCodeProperties;

    /**
     * 生成验证码
     *
     * @param request
     * @return
     */
    @Override
    public ValidateCodeDo generate(HttpServletRequest request) {
        String code = RandomStringUtils.randomNumeric(validateCodeProperties.getSms().getLength());
        return new ValidateCodeDo(code);
    }
}
