package top.doudou.common.verification.code.sms;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import top.doudou.common.verification.code.AbstractValidateCodeProcessor;
import top.doudou.common.verification.code.CodeConstant;
import top.doudou.common.verification.code.entity.ValidateCodeDo;
import top.doudou.core.exception.CustomException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @Description 短信验证码处理器
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2022-01-20 14:59
 */
@Component("smsValidateCodeProcessor")
@ConditionalOnMissingBean(name = "smsValidateCodeProcessor")
public class SmsCodeProcessor extends AbstractValidateCodeProcessor<ValidateCodeDo> {

    /**
     * 短信验证码发送器
     */
    @Autowired
    private SmsCodeSender smsCodeSender;


    @Override
    protected void send(HttpServletRequest request, HttpServletResponse response,ValidateCodeDo validateCodeDo) {
        String paramName = CodeConstant.DEFAULT_PARAMETER_NAME_MOBILE;
        String mobile = null;
        try {
            mobile = ServletRequestUtils.getRequiredStringParameter(request, paramName);
            smsCodeSender.send(mobile, validateCodeDo.getCode());
        } catch (ServletRequestBindingException e) {
            throw new CustomException(e);
        }

    }

}