/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.verification.code;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.ServletWebRequest;
import top.doudou.common.verification.code.StorageStrategy;
import top.doudou.common.verification.code.ValidateCodeGenerator;
import top.doudou.common.verification.code.ValidateCodeProcessor;
import top.doudou.common.verification.code.ValidateCodeType;
import top.doudou.common.verification.code.entity.ValidateCodeDo;
import top.doudou.common.verification.code.properties.ValidateCodeProperties;
import top.doudou.core.exception.ValidateCodeException;

public abstract class AbstractValidateCodeProcessor<C extends ValidateCodeDo>
implements ValidateCodeProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractValidateCodeProcessor.class);
    @Autowired
    private Map<String, ValidateCodeGenerator> validateCodeGenerators;
    @Autowired
    private StorageStrategy<ValidateCodeDo> storageStrategy;
    @Autowired
    private ValidateCodeProperties validateCodeProperties;
    @Autowired
    private HttpServletRequest request;

    @Override
    public void create(HttpServletRequest request, HttpServletResponse response) {
        C validateCode = this.generate(request);
        this.save(request, validateCode);
        this.send(request, response, validateCode);
    }

    @Override
    public void create(ServletWebRequest request) {
        C validateCode = this.generate(request.getRequest());
        this.save(request.getRequest(), validateCode);
        this.send(request.getRequest(), request.getResponse(), validateCode);
    }

    private C generate(HttpServletRequest request) {
        String type = this.getValidateCodeType(request).toString().toLowerCase();
        String generatorName = type + ValidateCodeGenerator.class.getSimpleName();
        ValidateCodeGenerator validateCodeGenerator = this.validateCodeGenerators.get(generatorName);
        if (validateCodeGenerator == null) {
            throw new ValidateCodeException("\u9a8c\u8bc1\u7801\u751f\u6210\u5668" + generatorName + "\u4e0d\u5b58\u5728");
        }
        return (C)validateCodeGenerator.generate(request);
    }

    private void save(HttpServletRequest request, C validateCode) {
        ValidateCodeType type = this.getValidateCodeType(request);
        String key = this.storageStrategy.createKey(request, type);
        log.info("---->  key  :{}", (Object)key);
        int expireIn = 0;
        if (ValidateCodeType.SMS.equals((Object)type)) {
            expireIn = this.validateCodeProperties.getSms().getExpireIn();
        } else if (ValidateCodeType.IMAGE.equals((Object)type)) {
            expireIn = this.validateCodeProperties.getImage().getExpireIn();
        }
        this.storageStrategy.save(key, (ValidateCodeDo)validateCode, expireIn);
    }

    protected abstract void send(HttpServletRequest var1, HttpServletResponse var2, C var3);

    private ValidateCodeType getValidateCodeType(HttpServletRequest request) {
        String type = StringUtils.substringBefore((String)this.getClass().getSimpleName(), (String)"CodeProcessor");
        return ValidateCodeType.valueOf(type.toUpperCase());
    }

    @Override
    public void validate(HttpServletRequest request) {
        String codeInRequest;
        ValidateCodeType processorType = this.getValidateCodeType(request);
        String key = this.storageStrategy.createKey(request, processorType);
        ValidateCodeDo validateCodeDo = this.storageStrategy.get(key);
        try {
            codeInRequest = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)processorType.getParamNameOnValidate());
        }
        catch (ServletRequestBindingException e) {
            throw new ValidateCodeException("\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)codeInRequest)) {
            throw new ValidateCodeException("\u9a8c\u8bc1\u7801\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (validateCodeDo == null || !StringUtils.equals((CharSequence)validateCodeDo.getCode(), (CharSequence)codeInRequest)) {
            throw new ValidateCodeException("\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u5df2\u8fc7\u671f");
        }
        this.storageStrategy.delete(key);
    }

    @Override
    public void validate() {
        this.validate(this.request);
    }
}

