/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.verification.code;

import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import top.doudou.common.redis.RedisUtil;
import top.doudou.common.verification.code.StorageStrategy;
import top.doudou.common.verification.code.ValidateCodeType;
import top.doudou.common.verification.code.entity.ValidateCodeDo;
import top.doudou.core.exception.CustomException;

@Component
@ConditionalOnMissingBean(name={"storageStrategy"})
public class RedisStorageStrategy
implements StorageStrategy<ValidateCodeDo> {
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void save(String key, ValidateCodeDo value, int expire) {
        this.redisUtil.set(key, (Object)value, Long.valueOf(expire).longValue());
    }

    @Override
    public ValidateCodeDo get(String key) {
        return (ValidateCodeDo)this.redisUtil.get(key);
    }

    @Override
    public void delete(String key) {
        this.redisUtil.del(new String[]{key});
    }

    @Override
    public String createKey(HttpServletRequest request, ValidateCodeType type) {
        String sessionId = request.getSession().getId();
        if (ValidateCodeType.SMS.equals((Object)type)) {
            String mobile = request.getParameter("mobile");
            return "VALIDATE_CODE_" + (Object)((Object)type) + "_" + mobile + "_" + sessionId;
        }
        if (ValidateCodeType.IMAGE.equals((Object)type)) {
            return "VALIDATE_CODE_" + (Object)((Object)type) + "_" + sessionId;
        }
        throw new CustomException("\u6682\u65f6\u4e0d\u652f\u6301\u8be5\u4e2d\u7c7b\u578b\uff1a" + (Object)((Object)type));
    }
}

