/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.verification.code.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.ServletRequestUtils;
import top.doudou.common.verification.code.ValidateCodeGenerator;
import top.doudou.common.verification.code.entity.ImageCodeDo;
import top.doudou.common.verification.code.properties.ValidateCodeProperties;

@Component(value="imageValidateCodeGenerator")
public class ImageCodeGenerator
implements ValidateCodeGenerator {
    @Autowired
    private ValidateCodeProperties validateCodeProperties;

    @Override
    public ImageCodeDo generate(HttpServletRequest request) {
        int width = this.validateCodeProperties.getImage().getWidth();
        int height = this.validateCodeProperties.getImage().getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        Random random = new Random();
        g.fillRect(0, 0, width, height);
        g.setFont(new Font("Times New Roman", 2, 20));
        for (int i = 0; i < 155; ++i) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            g.drawLine(x, y, x + xl, y + yl);
        }
        String sRand = "";
        for (int i = 0; i < ServletRequestUtils.getIntParameter((ServletRequest)request, (String)"codeLength", (int)this.validateCodeProperties.getImage().getLength()); ++i) {
            String rand = String.valueOf(random.nextInt(10));
            sRand = sRand + rand;
            g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
            g.drawString(rand, 13 * i + 6, 16);
        }
        g.dispose();
        return new ImageCodeDo(image, sRand);
    }
}

