/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.verification.code.image;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import top.doudou.common.verification.code.AbstractValidateCodeProcessor;
import top.doudou.common.verification.code.entity.ImageCodeDo;
import top.doudou.core.exception.CustomException;

@Component(value="imageValidateCodeProcessor")
@ConditionalOnMissingBean(name={"imageValidateCodeProcessor"})
public class ImageCodeProcessor
extends AbstractValidateCodeProcessor<ImageCodeDo> {
    @Override
    protected void send(HttpServletRequest request, HttpServletResponse response, ImageCodeDo imageCodeDo) {
        response.setContentType("image/jpeg");
        try {
            ImageIO.write((RenderedImage)imageCodeDo.getImage(), "JPEG", (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new CustomException((Throwable)e);
        }
    }
}

