/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.verification.code.sms;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import top.doudou.common.redis.RedisUtil;
import top.doudou.common.redis.adapter.SmsStrategyAdapter;
import top.doudou.common.sms.details.client.SmsSendClient;
import top.doudou.common.sms.details.properties.ALiYunProperties;
import top.doudou.common.verification.code.properties.SmsCodeProperties;
import top.doudou.common.verification.code.properties.ValidateCodeProperties;
import top.doudou.common.verification.code.sms.SmsCodeSender;

@Component
@ConditionalOnMissingBean(name={"smsCodeSender"})
@EnableConfigurationProperties(value={ALiYunProperties.class})
public class DefaultSmsCodeSender
implements SmsCodeSender {
    private static final Logger log = LoggerFactory.getLogger(DefaultSmsCodeSender.class);
    @Autowired
    private SmsSendClient smsSendClient;
    @Autowired
    private ValidateCodeProperties validateCodeProperties;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void send(String mobile, String code) {
        log.info("\u9ed8\u8ba4\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u7684\u65b9\u5f0f     ------>  \u624b\u673a\u53f7:{}     \u9a8c\u8bc1\u7801:{}", (Object)mobile, (Object)code);
        SmsCodeProperties sms = this.validateCodeProperties.getSms();
        SmsStrategyAdapter smsStrategyAdapter = new SmsStrategyAdapter(this.redisUtil, sms.getDayMax(), sms.getCoolingTime());
        smsStrategyAdapter.handler(mobile);
        log.info("  \u53d1\u9001\u6210\u529f --\u300b");
    }
}

