/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.common.verification.code.sms;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import top.doudou.common.verification.code.AbstractValidateCodeProcessor;
import top.doudou.common.verification.code.entity.ValidateCodeDo;
import top.doudou.common.verification.code.sms.SmsCodeSender;
import top.doudou.core.exception.CustomException;

@Component(value="smsValidateCodeProcessor")
@ConditionalOnMissingBean(name={"smsValidateCodeProcessor"})
public class SmsCodeProcessor
extends AbstractValidateCodeProcessor<ValidateCodeDo> {
    @Autowired
    private SmsCodeSender smsCodeSender;

    @Override
    protected void send(HttpServletRequest request, HttpServletResponse response, ValidateCodeDo validateCodeDo) {
        String paramName = "mobile";
        String mobile = null;
        try {
            mobile = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)paramName);
            this.smsCodeSender.send(mobile, validateCodeDo.getCode());
        }
        catch (ServletRequestBindingException e) {
            throw new CustomException((Throwable)e);
        }
    }
}

