package top.doudou.web.socket.config;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.io.File;

/**
 * @Description 线程配置
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-10-23 11:26
 * @Version V1.0
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "log")
public class LogProperties {

    private String path = System.getProperty("user.home") + File.separator+"log"+File.separator;

    private String name = "output.log";

    public String getPath(){
        if(StringUtils.endsWith(path,File.separator)){
            return this.path;
        }
        return path + File.separator;
    }

}
