/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.web.socket;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import top.doudou.base.exception.ExceptionUtils;
import top.doudou.base.util.LogUtil;
import top.doudou.base.util.file.FileReadAndWriteUtil;
import top.doudou.web.socket.config.FastEndpointConfigure;
import top.doudou.web.socket.config.LogProperties;
import top.doudou.web.socket.handler.AbsFastWebSocketHandler;

@Component
@ServerEndpoint(value="/websocket/dynamic/log", configurator=FastEndpointConfigure.class)
@EnableConfigurationProperties(value={LogProperties.class})
public class DynamicLogServer
extends AbsFastWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(DynamicLogServer.class);
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired
    private LogProperties logProperties;
    private static Map<String, Integer> lengthMap = new ConcurrentHashMap<String, Integer>();

    @Override
    @OnOpen
    public void onOpen(Session session) {
        this.open(session);
        lengthMap.put(session.getId(), 1);
        new Thread(() -> {
            boolean first = true;
            while (sessionMap.get(session.getId()) != null) {
                try {
                    Object[] lines = FileReadAndWriteUtil.read((String)(this.logProperties.getPath() + this.applicationName + File.separator + this.logProperties.getName()));
                    Object[] copyOfRange = Arrays.copyOfRange(lines, (int)lengthMap.get(session.getId()), lines.length);
                    lengthMap.replace(session.getId(), lines.length);
                    if (copyOfRange.length > 0) {
                        String result = LogUtil.handler((Object[])copyOfRange, (boolean)first);
                        this.send(session, result);
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    log.error(ExceptionUtils.toString((Exception)e));
                }
            }
        }).start();
    }

    @Override
    @OnClose
    public void onClose(Session session) {
        super.close(session);
        lengthMap.remove(session.getId());
    }

    @Override
    @OnError
    public void onError(Session session, Throwable error) {
        super.error(session, error);
    }

    @Override
    @OnMessage
    public void onMessage(String message, Session session) {
    }

    public static void main(String[] args) {
        String str = "<br/>2020-11-07 11:22:40&nbsp;&nbsp;&nbsp;[<span style='color: green;'>INFO</span> ]&nbsp;&nbsp;&nbsp;[http-nio-9093-exec-9]&nbsp;&nbsp;&nbsp;<span style='color: black;'>top.doudou.common.tool.aspect.RequestLogBaseAspect</span>&nbsp;&nbsp;&nbsp;[55] &nbsp;&nbsp;&nbsp;<span style='color: green;'> [1bb91801b0294bcad]</span>&nbsp;&nbsp;&nbsp;<span style='color: green;'>========================START========================</span>";
        str.replaceAll(" ", "&nbsp;");
    }
}

