/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.web.socket.handler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.doudou.base.exception.ExceptionUtils;
import top.doudou.web.socket.entity.MessageDto;

public abstract class AbsFastWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(AbsFastWebSocketHandler.class);
    protected static Map<String, Session> sessionMap = new ConcurrentHashMap<String, Session>();
    protected static LongAdder count = new LongAdder();

    public void onOpen(Session session) {
    }

    public void onOpen(Long userId, Session session) {
    }

    public void onOpen(String uniqueKey, Session session) {
    }

    public abstract void onClose(Session var1);

    public abstract void onError(Session var1, Throwable var2);

    public abstract void onMessage(String var1, Session var2);

    public void sendAll(MessageDto message) {
        sessionMap.forEach((key, value) -> this.send((Session)value, message));
    }

    protected void open(Session session) {
        count.increment();
        log.info("\u65b0\u7684\u8fde\u63a5\uff1a{},\u5f53\u524d\u8fde\u63a5\u7684\u4eba\u6570\uff1a{}", (Object)session.getId(), (Object)count.intValue());
        sessionMap.put(session.getId(), session);
    }

    protected void close(Session session) {
        sessionMap.remove(session.getId());
        count.decrement();
        log.info("\u8fde\u63a5\u5173\u95ed\u4e86\uff1a{},\u5f53\u524d\u5728\u7ebf\u7684\u4eba\u6570\uff1a{}", (Object)session.getId(), (Object)count.intValue());
    }

    protected void error(Session session, Throwable error) {
        log.info("\u8fde\u63a5\u53d1\u751f\u4e86\u9519\u8bef\uff1a{},\u9519\u8bef\u7684\u539f\u56e0\u4e3a\uff1a{}", (Object)session.getId(), (Object)error.getLocalizedMessage());
        log.error(ExceptionUtils.toString((Throwable)error));
    }

    protected void message(String message, Session session) {
        System.out.println("\u6536\u5230\u6d88\u606f\uff1a" + message);
    }

    protected void send(Session session, MessageDto message) {
        try {
            session.getBasicRemote().sendObject((Object)message);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.toString((Exception)e));
        }
    }

    protected void send(Session session, String message) {
        try {
            session.getBasicRemote().sendText(message);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.toString((Exception)e));
        }
    }
}

