package top.doudou.web.socket.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

import javax.websocket.server.ServerEndpointConfig;

/**
 * @Description 解决注入其他类的问题，
 * 详情参考这篇帖子：webSocket无法注入其他类：https://blog.csdn.net/tornadojava/article/details/78781474
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-10-14 15:06
 * @Version V1.0
 */
@Configuration
public class FastEndpointConfigure extends ServerEndpointConfig.Configurator implements ApplicationContextAware {

    private static volatile BeanFactory context;

    @Override
    public <T> T getEndpointInstance(Class<T> clazz){
        return context.getBean(clazz);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        FastEndpointConfigure.context = applicationContext;
    }
}