package top.doudou.web.socket.entity;

import lombok.Data;

import java.util.Date;

/**
 * @Description
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-10-24 15:51
 * @Version V1.0
 */
@Data
public class MessageDto {

    /**
     * 发送者
     */
    private Long sender;

    /**
     * 接收者
     */
    private Long receive;

    /**
     * 消息
     */
    private String message;

    /**
     * 发送时间
     */
    private Date time;

    public MessageDto(){};

    public MessageDto(String message){
        this.message = message;
        this.time = new Date();
    }

    public MessageDto(Long sender,Long receive,String message){
        this.message = message;
        this.time = new Date();
        this.sender = sender;
        this.receive = receive;
    }

    @Override
    public String toString() {
        return "MessageDto{" +
                "sender=" + sender +
                ", receive=" + receive +
                ", message='" + message + '\'' +
                ", time=" + time +
                '}';
    }
}
