/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.web.socket;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import top.doudou.web.socket.config.FastEndpointConfigure;
import top.doudou.web.socket.entity.MessageDto;
import top.doudou.web.socket.handler.AbsFastWebSocketHandler;

@Component
@ServerEndpoint(value="/websocket/notice/{userId}", configurator=FastEndpointConfigure.class)
public class WebSocketNoticeServer
extends AbsFastWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(WebSocketNoticeServer.class);
    private static Map<String, Integer> lengthMap = new ConcurrentHashMap<String, Integer>();
    private static Map<Long, List<Session>> userMap = new ConcurrentHashMap<Long, List<Session>>();

    @Override
    @OnOpen
    public void onOpen(@PathParam(value="userId") Long userId, Session session) {
        this.open(session);
        this.cacheUser(userId, session);
    }

    @Override
    @OnClose
    public void onClose(Session session) {
        super.close(session);
        lengthMap.remove(session.getId());
    }

    @Override
    @OnError
    public void onError(Session session, Throwable error) {
        super.error(session, error);
    }

    @Override
    @OnMessage
    public void onMessage(String message, Session session) {
        this.message(message, session);
    }

    public boolean send(Long userId, MessageDto messageDto) {
        List<Session> list = userMap.get(userId);
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        list.forEach(item -> this.send((Session)item, messageDto));
        return true;
    }

    private synchronized void cacheUser(Long userId, Session session) {
        List<Session> list = userMap.get(userId);
        if (CollectionUtils.isEmpty(list)) {
            ArrayList<Session> temp = new ArrayList<Session>();
            temp.add(session);
            userMap.put(userId, temp);
            return;
        }
        list.add(session);
        userMap.put(userId, list);
    }
}

