package top.doudou.web.socket.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import top.doudou.web.socket.WebSocketNoticeServer;
import top.doudou.web.socket.entity.MessageDto;

/**
 * @Description
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-10-22 14:54
 * @Version V1.0
 */
@RestController
@RequestMapping("/web/socket")
public class WebSocketController {

    @Autowired
    private WebSocketNoticeServer webSocketNoticeServer;

    @GetMapping("/notice/{userId}")
    public String noticeUser(@PathVariable("userId") Long userId,String message) {
        if(null == userId){
            webSocketNoticeServer.sendAll(new MessageDto(message));
        }else {
            webSocketNoticeServer.send(userId,new MessageDto(message));
        }
        return "发送成功";
    }


}
