/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.web.socket;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import top.doudou.core.exception.ExceptionUtils;
import top.doudou.core.properties.CustomLogProperties;
import top.doudou.core.util.LogUtil;
import top.doudou.core.util.file.FileReadAndWriteUtil;
import top.doudou.web.socket.config.FastEndpointConfigure;
import top.doudou.web.socket.handler.AbsFastWebSocketHandler;

@Component
@ServerEndpoint(value="/dynamic/{applicationName}", configurator=FastEndpointConfigure.class)
@EnableConfigurationProperties(value={CustomLogProperties.class})
public class DynamicLogEndpoint
extends AbsFastWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(DynamicLogEndpoint.class);
    @Autowired
    private CustomLogProperties customLogProperties;
    private static Map<String, Integer> lengthMap = new ConcurrentHashMap<String, Integer>();

    @OnOpen
    public void onOpen(Session session, @PathParam(value="applicationName") String applicationName) {
        this.setWebsocketType("\u5176\u4ed6\u670d\u52a1\u52a8\u6001\u65e5\u5fd7");
        this.open(session);
        if (StringUtils.isBlank((CharSequence)applicationName) || "undefined".equals(applicationName)) {
            this.send(session, "\u8bf7\u5728\u5730\u5740\u680f\u4f20\u5165\u5e94\u7528\u7684\u540d\u5b57\uff0c\u4f8b\u5982\uff1a?name=user");
            return;
        }
        String filePath = this.customLogProperties.getDefaultLogFile();
        if (!new File(filePath).exists()) {
            this.send(session, "\u670d\u52a1\u540d\u6216\u8005\u6587\u4ef6\u7684\u8def\u5f84\u9519\u8bef\uff0c\u6545\u65e0\u6cd5\u8bfb\u53d6\u5230\u4e89\u53d6\u7684\u65e5\u5fd7");
            return;
        }
        lengthMap.put(session.getId(), 1);
        new Thread(() -> {
            boolean first = true;
            while (sessionMap.get(session.getId()) != null) {
                try {
                    Object[] lines = FileReadAndWriteUtil.read((String)filePath);
                    Object[] copyOfRange = Arrays.copyOfRange(lines, (int)lengthMap.get(session.getId()), lines.length);
                    lengthMap.replace(session.getId(), lines.length);
                    if (copyOfRange.length > 0) {
                        String result = LogUtil.handler((Object[])copyOfRange, (boolean)first);
                        this.send(session, result);
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    log.error(ExceptionUtils.toString((Exception)e));
                }
            }
        }).start();
    }

    @Override
    @OnClose
    public void onClose(Session session) {
        super.close(session);
        lengthMap.remove(session.getId());
    }

    @Override
    @OnError
    public void onError(Session session, Throwable error) {
        super.error(session, error);
    }

    @Override
    @OnMessage
    public void onMessage(String message, Session session) {
    }
}

