package top.aoyudi.deepseek.entity.request;

import lombok.Data;
import top.aoyudi.chat.entity.ChatMessage;
import top.aoyudi.deepseek.entity.model.DeepSeekChatModel;
import top.aoyudi.deepseek.entity.model.DeepSeekModel;
import top.aoyudi.deepseek.entity.model.DeepSeekReasonerModel;
import top.aoyudi.deepseek.entity.request.tool.DSReqTool;

import java.util.List;

/**
 * DeepSeek最终请求体
 */
@Data
public class FinallyRequestBody {
    // 消息列表 1
    private List<ChatMessage> messages;

    // 模型id
    private String model;

    // 流
    private boolean stream;

    // 降低模型重复相同内容的可能性
    private double frequency_penalty;

    // 限制一次请求中模型生成 completion 的最大 token 数
    private int max_tokens;

    // 从而增加模型谈论新主题的可能性。
    private double presence_penalty;

    // 采样温度，介于 0 和 2 之间。更高的值，如 0.8，会使输出更随机，而更低的值，如 0.2，会使其更加集中和确定。
    private double temperature;
    // 作为调节采样温度的替代方案，模型会考虑前 top_p 概率的 token 的结果。所以 0.1 就意味着只有包括在最高 10% 概率中的 token 会被考虑。
    private double top_p;

    // 工具
    private DSReqTool tools;

    // 是否返回所输出 token 的对数概率。如果为 true，则在 message 的 content 中返回每个输出 token 的对数概率。
    // private boolean logprobs;

    // 一个介于 0 到 20 之间的整数 N，指定每个输出位置返回输出概率 top N 的 token，且返回这些 token 的对数概率。指定此参数时，logprobs 必须为 true。
    // private int top_logprobs;

    public FinallyRequestBody(DeepSeekRequest deepSeekRequest){
        // 挨个赋值
        this.messages = deepSeekRequest.getMessages();
        tools = deepSeekRequest.getTools();
        // model
        DeepSeekModel theDeepSeekModel = deepSeekRequest.getDeepSeekModel();
        if(theDeepSeekModel instanceof DeepSeekChatModel){
            DeepSeekChatModel deepSeekModel = (DeepSeekChatModel) theDeepSeekModel;
            this.model=deepSeekModel.getModel();
            this.stream=deepSeekModel.isStream();
        }
        if (theDeepSeekModel instanceof DeepSeekReasonerModel){
            DeepSeekReasonerModel deepSeekModel = (DeepSeekReasonerModel) theDeepSeekModel;
            this.model=deepSeekModel.getModel();
            this.stream=deepSeekModel.isStream();
        }
        this.frequency_penalty= theDeepSeekModel.getFrequency_penalty();
        this.max_tokens= theDeepSeekModel.getMax_tokens();
        this.presence_penalty= theDeepSeekModel.getPresence_penalty();
        this.temperature= theDeepSeekModel.getTemperature();
        this.top_p= theDeepSeekModel.getTop_p();
    }
}
