package top.aoyudi.starter;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * DeepSeek 自动配置实体
 */
@Data
@ConfigurationProperties(prefix = "deepseek")
public class DeepSeekProperties {
    /**
     * DeepSeek API Key
     */
    private String apiKey;
    /**
     * DeepSeek API URL
     */
    private String apiUrl = "https://api.deepseek.com/chat/completions"; // 默认值
}