/*
 * Decompiled with CFR 0.152.
 */
package top.aoyudi.deepseek.entity.request;

import java.util.List;
import top.aoyudi.chat.entity.ChatMessage;
import top.aoyudi.deepseek.entity.model.DeepSeekChatModel;
import top.aoyudi.deepseek.entity.model.DeepSeekModel;
import top.aoyudi.deepseek.entity.model.DeepSeekReasonerModel;
import top.aoyudi.deepseek.entity.request.DeepSeekRequest;
import top.aoyudi.deepseek.entity.request.tool.DSReqTool;

public class FinallyRequestBody {
    private List<ChatMessage> messages;
    private String model;
    private boolean stream;
    private double frequency_penalty;
    private int max_tokens;
    private double presence_penalty;
    private double temperature;
    private double top_p;
    private DSReqTool tools;

    public FinallyRequestBody(DeepSeekRequest deepSeekRequest) {
        DeepSeekModel deepSeekModel;
        this.messages = deepSeekRequest.getMessages();
        this.tools = deepSeekRequest.getTools();
        DeepSeekModel theDeepSeekModel = deepSeekRequest.getDeepSeekModel();
        if (theDeepSeekModel instanceof DeepSeekChatModel) {
            deepSeekModel = (DeepSeekChatModel)theDeepSeekModel;
            this.model = ((DeepSeekChatModel)deepSeekModel).getModel();
            this.stream = ((DeepSeekChatModel)deepSeekModel).isStream();
        }
        if (theDeepSeekModel instanceof DeepSeekReasonerModel) {
            deepSeekModel = (DeepSeekReasonerModel)theDeepSeekModel;
            this.model = ((DeepSeekReasonerModel)deepSeekModel).getModel();
            this.stream = ((DeepSeekReasonerModel)deepSeekModel).isStream();
        }
        this.frequency_penalty = theDeepSeekModel.getFrequency_penalty();
        this.max_tokens = theDeepSeekModel.getMax_tokens();
        this.presence_penalty = theDeepSeekModel.getPresence_penalty();
        this.temperature = theDeepSeekModel.getTemperature();
        this.top_p = theDeepSeekModel.getTop_p();
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public String getModel() {
        return this.model;
    }

    public boolean isStream() {
        return this.stream;
    }

    public double getFrequency_penalty() {
        return this.frequency_penalty;
    }

    public int getMax_tokens() {
        return this.max_tokens;
    }

    public double getPresence_penalty() {
        return this.presence_penalty;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getTop_p() {
        return this.top_p;
    }

    public DSReqTool getTools() {
        return this.tools;
    }

    public void setMessages(List<ChatMessage> messages) {
        this.messages = messages;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setFrequency_penalty(double frequency_penalty) {
        this.frequency_penalty = frequency_penalty;
    }

    public void setMax_tokens(int max_tokens) {
        this.max_tokens = max_tokens;
    }

    public void setPresence_penalty(double presence_penalty) {
        this.presence_penalty = presence_penalty;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public void setTop_p(double top_p) {
        this.top_p = top_p;
    }

    public void setTools(DSReqTool tools) {
        this.tools = tools;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FinallyRequestBody)) {
            return false;
        }
        FinallyRequestBody other = (FinallyRequestBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        if (Double.compare(this.getFrequency_penalty(), other.getFrequency_penalty()) != 0) {
            return false;
        }
        if (this.getMax_tokens() != other.getMax_tokens()) {
            return false;
        }
        if (Double.compare(this.getPresence_penalty(), other.getPresence_penalty()) != 0) {
            return false;
        }
        if (Double.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (Double.compare(this.getTop_p(), other.getTop_p()) != 0) {
            return false;
        }
        List<ChatMessage> this$messages = this.getMessages();
        List<ChatMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        DSReqTool this$tools = this.getTools();
        DSReqTool other$tools = other.getTools();
        return !(this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FinallyRequestBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStream() ? 79 : 97);
        long $frequency_penalty = Double.doubleToLongBits(this.getFrequency_penalty());
        result = result * 59 + (int)($frequency_penalty >>> 32 ^ $frequency_penalty);
        result = result * 59 + this.getMax_tokens();
        long $presence_penalty = Double.doubleToLongBits(this.getPresence_penalty());
        result = result * 59 + (int)($presence_penalty >>> 32 ^ $presence_penalty);
        long $temperature = Double.doubleToLongBits(this.getTemperature());
        result = result * 59 + (int)($temperature >>> 32 ^ $temperature);
        long $top_p = Double.doubleToLongBits(this.getTop_p());
        result = result * 59 + (int)($top_p >>> 32 ^ $top_p);
        List<ChatMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        DSReqTool $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        return result;
    }

    public String toString() {
        return "FinallyRequestBody(messages=" + this.getMessages() + ", model=" + this.getModel() + ", stream=" + this.isStream() + ", frequency_penalty=" + this.getFrequency_penalty() + ", max_tokens=" + this.getMax_tokens() + ", presence_penalty=" + this.getPresence_penalty() + ", temperature=" + this.getTemperature() + ", top_p=" + this.getTop_p() + ", tools=" + this.getTools() + ")";
    }
}

