/*
 * Decompiled with CFR 0.152.
 */
package top.aoyudi.deepseek.service;

import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import top.aoyudi.deepseek.entity.enums.ErrorCodeEnum;
import top.aoyudi.deepseek.entity.request.DeepSeekRequest;
import top.aoyudi.deepseek.entity.request.FinallyRequestBody;
import top.aoyudi.deepseek.entity.response.DSResponse;
import top.aoyudi.starter.DeepSeekConfig;
import top.aoyudi.starter.DeepSeekProperties;

@Component
public class DeepSeekService {
    @Resource
    private DeepSeekConfig deepSeekConfig;
    private static final Logger logger = LoggerFactory.getLogger(DeepSeekService.class);
    private final DeepSeekProperties properties;
    private final RestTemplate restTemplate;

    public DeepSeekService(DeepSeekProperties properties) {
        this.properties = properties;
        this.restTemplate = new RestTemplate();
    }

    public DSResponse sendMessage(DeepSeekRequest request) {
        HttpHeaders headers = this.deepSeekConfig.createHeaders();
        FinallyRequestBody finallyRequestBody = new FinallyRequestBody(request);
        HttpEntity entity = new HttpEntity((Object)finallyRequestBody, (MultiValueMap)headers);
        logger.info("Sending request to DeepSeek API...");
        ResponseEntity response = this.restTemplate.exchange(this.properties.getApiUrl(), HttpMethod.POST, entity, DSResponse.class, new Object[0]);
        return this.handleResponse((ResponseEntity<DSResponse>)response);
    }

    private DSResponse handleResponse(ResponseEntity<DSResponse> response) {
        if (response.getStatusCodeValue() == 200) {
            logger.info("FinallyRequestBody successful.");
            return (DSResponse)response.getBody();
        }
        int statusCode = response.getStatusCode().value();
        ErrorCodeEnum errorCode = ErrorCodeEnum.fromCode(statusCode);
        String errorMessage = errorCode != null ? errorCode.getDescription() + ": " + errorCode.getReason() : "\u672a\u77e5\u9519\u8bef\uff1a\u8bf7\u8054\u7cfb\u652f\u6301";
        logger.error("FinallyRequestBody failed with error: {}", (Object)errorMessage);
        throw new RuntimeException(errorMessage);
    }
}

