/*
 * Decompiled with CFR 0.152.
 */
package top.aoyudi.deepseek.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Flux;
import top.aoyudi.deepseek.entity.request.DeepSeekRequest;
import top.aoyudi.deepseek.entity.request.FinallyRequestBody;
import top.aoyudi.deepseek.entity.response.DSResponse;
import top.aoyudi.starter.DeepSeekConfig;
import top.aoyudi.starter.DeepSeekProperties;

@Component
public class DeepSeekStreamService {
    private final DeepSeekProperties properties;
    private final RestTemplate restTemplate;
    private static final Logger logger = LoggerFactory.getLogger(DeepSeekStreamService.class);
    @Resource
    private DeepSeekConfig deepSeekConfig;

    public DeepSeekStreamService(DeepSeekProperties properties) {
        this.properties = properties;
        this.restTemplate = new RestTemplate();
    }

    public Flux<DSResponse> sendMessageWithStream(DeepSeekRequest request) {
        HttpHeaders headers = this.deepSeekConfig.createHeaders();
        if (request == null) {
            throw new IllegalArgumentException("FinallyRequestBody cannot be null");
        }
        FinallyRequestBody finallyRequestBody = new FinallyRequestBody(request);
        logger.info("Sending request to DeepSeek API...");
        return Flux.create(sink -> this.restTemplate.execute(this.properties.getApiUrl(), HttpMethod.POST, requestCallback -> {
            requestCallback.getHeaders().addAll((MultiValueMap)headers);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                String requestBody = objectMapper.writeValueAsString((Object)finallyRequestBody);
                requestCallback.getBody().write(requestBody.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, responseExtractor -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseExtractor.getBody()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    DSResponse dsResponse;
                    if (line.isBlank() || (dsResponse = this.parseLineToDSResponse(this.jsonProcessor(line))) == null) continue;
                    sink.next((Object)dsResponse);
                }
                sink.complete();
            }
            catch (Exception e) {
                sink.error((Throwable)e);
            }
            return null;
        }, new Object[0]));
    }

    private DSResponse parseLineToDSResponse(String line) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (DSResponse)objectMapper.readValue(line, DSResponse.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String jsonProcessor(String jsonString) throws JsonProcessingException {
        if (jsonString.contains("keep-alive") || jsonString.contains("DONE")) {
            System.out.println("Received keep-alive message, ignoring...");
            return null;
        }
        if (jsonString.startsWith("data: ")) {
            jsonString = jsonString.substring(6).trim();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(jsonString);
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
    }
}

