package top.aoyudi.deepseek.entity.request.tool;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class DSReqToolParameters {
    @JsonProperty("type")
    private final String type = "object";  // 固定值

    @JsonProperty("properties")
    private Map<String, Property> properties = new HashMap<>();

    @JsonProperty("required")
    private List<String> required = new ArrayList<>();

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Property {
        @JsonProperty("type")
        private String type;  // string/number/boolean等

        @JsonProperty("description")
        private String description;
    }
}
