/*
 * Decompiled with CFR 0.152.
 */
package top.aoyudi.deepseek.entity.request;

import java.util.ArrayList;
import java.util.List;
import top.aoyudi.chat.entity.ChatMessage;
import top.aoyudi.deepseek.entity.model.DeepSeekChatModel;
import top.aoyudi.deepseek.entity.model.DeepSeekModel;
import top.aoyudi.deepseek.entity.model.DeepSeekReasonerModel;
import top.aoyudi.deepseek.entity.request.DeepSeekRequest;
import top.aoyudi.deepseek.entity.request.tool.DSReqFunction;
import top.aoyudi.deepseek.entity.request.tool.DSReqTool;
import top.aoyudi.deepseek.handler.ToolRegister;

public class FinallyRequestBody {
    private List<ChatMessage> messages;
    private String model;
    private boolean stream;
    private double frequency_penalty;
    private int max_tokens;
    private double presence_penalty;
    private double temperature;
    private double top_p;
    private List<DSReqTool> tools;
    private Object tool_choice;

    public FinallyRequestBody(DeepSeekRequest deepSeekRequest) {
        DeepSeekModel deepSeekModel;
        DeepSeekModel theDeepSeekModel;
        this.messages = deepSeekRequest.getMessages();
        List<String> functionNameList = deepSeekRequest.getDeepSeekModel().getFunction_name_list();
        if (!functionNameList.isEmpty()) {
            ArrayList<DSReqTool> dsReqTools = new ArrayList<DSReqTool>();
            functionNameList.forEach(name -> {
                DSReqTool dsReqTool = new DSReqTool();
                DSReqFunction dsReqFunction = ToolRegister.getDsReqFunction(name);
                if (dsReqFunction == null) {
                    throw new IllegalStateException("\u8c03\u7528\u65b9\u6cd5\u4e0d\u5b58\u5728");
                }
                dsReqTool.setFunction(dsReqFunction);
                dsReqTools.add(dsReqTool);
            });
            this.tools = dsReqTools;
            this.tool_choice = deepSeekRequest.getDeepSeekModel().getTool_choice();
        }
        if ((theDeepSeekModel = deepSeekRequest.getDeepSeekModel()) instanceof DeepSeekChatModel) {
            deepSeekModel = (DeepSeekChatModel)theDeepSeekModel;
            this.model = ((DeepSeekChatModel)deepSeekModel).getModel();
            this.stream = ((DeepSeekChatModel)deepSeekModel).isStream();
        }
        if (theDeepSeekModel instanceof DeepSeekReasonerModel) {
            deepSeekModel = (DeepSeekReasonerModel)theDeepSeekModel;
            this.model = ((DeepSeekReasonerModel)deepSeekModel).getModel();
            this.stream = ((DeepSeekReasonerModel)deepSeekModel).isStream();
        }
        this.frequency_penalty = theDeepSeekModel.getFrequency_penalty();
        this.max_tokens = theDeepSeekModel.getMax_tokens();
        this.presence_penalty = theDeepSeekModel.getPresence_penalty();
        this.temperature = theDeepSeekModel.getTemperature();
        this.top_p = theDeepSeekModel.getTop_p();
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public String getModel() {
        return this.model;
    }

    public boolean isStream() {
        return this.stream;
    }

    public double getFrequency_penalty() {
        return this.frequency_penalty;
    }

    public int getMax_tokens() {
        return this.max_tokens;
    }

    public double getPresence_penalty() {
        return this.presence_penalty;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getTop_p() {
        return this.top_p;
    }

    public List<DSReqTool> getTools() {
        return this.tools;
    }

    public Object getTool_choice() {
        return this.tool_choice;
    }

    public void setMessages(List<ChatMessage> messages) {
        this.messages = messages;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setFrequency_penalty(double frequency_penalty) {
        this.frequency_penalty = frequency_penalty;
    }

    public void setMax_tokens(int max_tokens) {
        this.max_tokens = max_tokens;
    }

    public void setPresence_penalty(double presence_penalty) {
        this.presence_penalty = presence_penalty;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public void setTop_p(double top_p) {
        this.top_p = top_p;
    }

    public void setTools(List<DSReqTool> tools) {
        this.tools = tools;
    }

    public void setTool_choice(Object tool_choice) {
        this.tool_choice = tool_choice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FinallyRequestBody)) {
            return false;
        }
        FinallyRequestBody other = (FinallyRequestBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        if (Double.compare(this.getFrequency_penalty(), other.getFrequency_penalty()) != 0) {
            return false;
        }
        if (this.getMax_tokens() != other.getMax_tokens()) {
            return false;
        }
        if (Double.compare(this.getPresence_penalty(), other.getPresence_penalty()) != 0) {
            return false;
        }
        if (Double.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (Double.compare(this.getTop_p(), other.getTop_p()) != 0) {
            return false;
        }
        List<ChatMessage> this$messages = this.getMessages();
        List<ChatMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<DSReqTool> this$tools = this.getTools();
        List<DSReqTool> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        Object this$tool_choice = this.getTool_choice();
        Object other$tool_choice = other.getTool_choice();
        return !(this$tool_choice == null ? other$tool_choice != null : !this$tool_choice.equals(other$tool_choice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FinallyRequestBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStream() ? 79 : 97);
        long $frequency_penalty = Double.doubleToLongBits(this.getFrequency_penalty());
        result = result * 59 + (int)($frequency_penalty >>> 32 ^ $frequency_penalty);
        result = result * 59 + this.getMax_tokens();
        long $presence_penalty = Double.doubleToLongBits(this.getPresence_penalty());
        result = result * 59 + (int)($presence_penalty >>> 32 ^ $presence_penalty);
        long $temperature = Double.doubleToLongBits(this.getTemperature());
        result = result * 59 + (int)($temperature >>> 32 ^ $temperature);
        long $top_p = Double.doubleToLongBits(this.getTop_p());
        result = result * 59 + (int)($top_p >>> 32 ^ $top_p);
        List<ChatMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<DSReqTool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        Object $tool_choice = this.getTool_choice();
        result = result * 59 + ($tool_choice == null ? 43 : $tool_choice.hashCode());
        return result;
    }

    public String toString() {
        return "FinallyRequestBody(messages=" + this.getMessages() + ", model=" + this.getModel() + ", stream=" + this.isStream() + ", frequency_penalty=" + this.getFrequency_penalty() + ", max_tokens=" + this.getMax_tokens() + ", presence_penalty=" + this.getPresence_penalty() + ", temperature=" + this.getTemperature() + ", top_p=" + this.getTop_p() + ", tools=" + this.getTools() + ", tool_choice=" + this.getTool_choice() + ")";
    }
}

